"""
Ethoscope Node API Package

This package contains modular API components for the Ethoscope Node Server.
Each module handles a specific domain of functionality to improve maintainability
and separation of concerns.

Modules:
- base: Common infrastructure and utilities
- device_api: Device management and control
- backup_api: Backup system management
- sensor_api: Sensor data and configuration
- roi_template_api: ROI template management
- node_api: Node system management
- file_api: File operations and downloads
- database_api: Database queries and experiments
- setup_api: Installation wizard and first-time setup
- tunnel_utils: Tunnel configuration and URL management utilities
"""

from .base import BaseAPI
from .device_api import DeviceAPI
from .backup_api import BackupAPI
from .sensor_api import SensorAPI
from .roi_template_api import ROITemplateAPI
from .node_api import NodeAPI
from .file_api import FileAPI
from .database_api import DatabaseAPI
from .setup_api import SetupAPI
from .tunnel_utils import TunnelUtils
from .auth_api import AuthAPI

__all__ = [
    'BaseAPI',
    'DeviceAPI', 
    'BackupAPI',
    'SensorAPI',
    'ROITemplateAPI',
    'NodeAPI',
    'FileAPI',
    'DatabaseAPI',
    'SetupAPI',
    'TunnelUtils',
    'AuthAPI'
]